using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using MelissaData;

namespace WindowsFormsApplication1
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
            
        }
        //********************** DATA FILE PATHS **********************
        //  This sample sets the data file path to the installation  
        //  default.  If you installed your Melissa Data data files to 
        //  a different path, enter that location it below.            
        //  The Data Files Directory must contain the following files: 
        //  mdDomain.dat, mdEmail.ini and mdEmailConfig.ini.           
        //*************************************************************
        const string dFILELOC = "C:\\Program Files\\Melissa DATA\\DQT\\Data";
        // ********************** LICENSE STRINGS ***********************
        //    You will need a valid license string to use Name Object,   
        //   please call a sales representative at 1-800-MELISSA ext. 3 
        //        (1-800-635-4772 x3) for a license string, then          
        //            REPLACE "DEMO" with your LICENSE STRING                    

        //   SetLicenseString will also check for a valid license in  
        //   the MD_LICENSE(Environment) variable. This allows you   
        //   to modify the license without recompiling the project
        // **************************************************************
        const string dLICENSE = "DEMO";

        //Name Object interface

        public MelissaData.mdName mdName;

        private void Form1_Load(object sender, EventArgs e)
        {
            #region Initialization
            //Initialize Name Object interface

            mdName = new MelissaData.mdName();

            //Set the license string
            mdName.SetLicenseString(dLICENSE);

            //Set path to the data files
            mdName.SetPathToNameFiles(dFILELOC);

            //Create a variable to check for a successful initialization
            MelissaData.mdName.ProgramStatus nameInitializeStatus = new MelissaData.mdName.ProgramStatus();

            //Name Object initialization and status reporting
            nameInitializeStatus = mdName.InitializeDataFiles();
            if (nameInitializeStatus.Equals(mdName.ProgramStatus.LicenseExpired))
            {
                label_initializationError.ForeColor = Color.Red;
                label_initializationError.Text = "License expired. Please contact a Melissa Data sales representative";
                button_verify.Enabled = false;
            }
            else
            {
                if (nameInitializeStatus.Equals(mdName.ProgramStatus.NoError))
                {
                    label_initializationError.ForeColor = Color.Blue;
                    label_BuildNumbr.ForeColor = Color.Blue;
                    label_ExpirationDate.ForeColor = Color.Blue;
                    label_DatabaseDate.ForeColor = Color.Blue;

                    label_BuildNumbr.Text = mdName.GetBuildNumber();
                    label_DatabaseDate.Text = mdName.GetDatabaseDate();
                    label_ExpirationDate.Text = mdName.GetLicenseExpirationDate();
                    label_initializationError.Text = "None";
                }
                else
                {
                    label_initializationError.ForeColor = Color.Red;
                    label_initializationError.Text = mdName.GetInitializeErrorString();
                }
            }

            #endregion

        }

        #region NameObject
        private void button_verify_Click(object sender, EventArgs e)
        {
            clearOutputs();
            //Input the full name into the Name Object
            mdName.SetFullName(txt_inputName.Text);

            //Set the settings for salutations
            mdName.SetSalutationSlug(txt_inputsalutationslug.Text);
            mdName.SetSalutationPrefix(txt_inputPrefix.Text);
            mdName.SetSalutationSuffix(txt_inputSuffix.Text);

            //Set the correct first spelling option
            if (combox_correctFirstSpelling.Text == "True")
                mdName.SetFirstNameSpellingCorrection(1);
            else if(combox_correctFirstSpelling.Text=="false")
                mdName.SetFirstNameSpellingCorrection(0);

            //Set the Gender Aggression
            if(combox_genderaggression.Text.Equals("Aggressive"))
                mdName.SetGenderAggression(MelissaData.mdName.Aggression.Aggressive);
            else if(combox_genderaggression.Text.Equals("Neutral"))
                mdName.SetGenderAggression(MelissaData.mdName.Aggression.Neutral);
            else if(combox_genderaggression.Text.Equals("Conservative"))
                mdName.SetGenderAggression(MelissaData.mdName.Aggression.Conservative);

            //Set Gender Population
            if(combox_genderPop.Text.Equals("Neutral"))
                mdName.SetGenderPopulation(MelissaData.mdName.Population.Mixed);
            else if(combox_genderPop.Text.Contains("female"))
                mdName.SetGenderPopulation(MelissaData.mdName.Population.Female);
            else if(combox_genderPop.Text.Contains("male"))
                mdName.SetGenderPopulation(MelissaData.mdName.Population.Male);

            //Set Primary Name Hint
            if(combox_primaryname.Text.Equals("DefinitelyFull"))
                mdName.SetPrimaryNameHint(MelissaData.mdName.NameHints.DefinitelyFull);
            else if(combox_primaryname.Text.Equals("VeryLikelyFull"))
                mdName.SetPrimaryNameHint(MelissaData.mdName.NameHints.VeryLikelyFull);
            else if(combox_primaryname.Text.Equals("ProbablyFull"))
                mdName.SetPrimaryNameHint(MelissaData.mdName.NameHints.ProbablyFull);
            else if(combox_primaryname.Text.Equals("Varying"))
                mdName.SetPrimaryNameHint(MelissaData.mdName.NameHints.Varying);
            else if(combox_primaryname.Text.Equals("ProbablyInverse"))
                mdName.SetPrimaryNameHint(MelissaData.mdName.NameHints.ProbablyInverse);
            else if(combox_primaryname.Text.Equals("VeryLikelyInverse"))
                mdName.SetPrimaryNameHint(MelissaData.mdName.NameHints.VeryLikelyInverse);
            else if(combox_primaryname.Text.Equals("DefinitelyInverse"))
                mdName.SetPrimaryNameHint(MelissaData.mdName.NameHints.DefinitelyInverse);
            else if(combox_primaryname.Text.Equals("MixedFirstName"))
                mdName.SetPrimaryNameHint(MelissaData.mdName.NameHints.MixedFirstName);
            else if(combox_primaryname.Text.Equals("MixedLastName"))
                mdName.SetPrimaryNameHint(MelissaData.mdName.NameHints.MixedLastName);


            //Parse out the results into the corresponding output fields
            mdName.Parse();
            txt_prefix1.Text = mdName.GetPrefix();
            txt_prefix2.Text = mdName.GetPrefix2();
            txt_first1.Text = mdName.GetFirstName();
            txt_first2.Text = mdName.GetFirstName2();
            txt_middle1.Text = mdName.GetMiddleName();
            txt_middle2.Text = mdName.GetMiddleName2();
            txt_last1.Text = mdName.GetLastName();
            txt_last2.Text = mdName.GetLastName2();
            txt_suffx1.Text = mdName.GetSuffix();
            txt_suffix2.Text = mdName.GetSuffix2();

            //Genderize and return the results into the corresponding output fields
            mdName.Genderize();
            txt_gender1.Text = mdName.GetGender();
            txt_gender2.Text = mdName.GetGender2();

            //Salutation and return the results into the corresponding output fields
            mdName.Salutate();
            txt_salutation.Text = mdName.GetSalutation();
			
			//Get our result codes
			txt_resultCodes.Text = mdName.GetResults();
            
        }
        #endregion

        private void clearOutputs()
        {
            txt_prefix1.Text = "";
            txt_prefix2.Text = "";
            txt_first1.Text = "";
            txt_first2.Text = "";
            txt_middle1.Text = "";
            txt_middle2.Text = "";
            txt_last1.Text = "";
            txt_last2.Text = "";
            txt_suffx1.Text = "";
            txt_suffix2.Text = "";
            txt_gender1.Text = "";
            txt_gender2.Text = "";
            txt_salutation.Text = "";
            txt_resultCodes.Text = "";
        }
    }
}
